/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWWSRRRegistry;
import filenet.vw.base.VWWSRRRegistryList;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRREvent;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRRRegistryItem;
import filenet.vw.toolkit.utils.ws.wsrr.VWConfigWSRRCustomPropertiesTableModel;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRBrowseTreeCellRenderer;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRProcessMonitorDialog;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRRegistryManager;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.api.wsrr.WSWSRRWsdlDocument;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class VWWSRRBrowsePanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
TreeWillExpandListener,
IVWToolbarBorderActionListener,
ItemSelectable,
MouseListener,
KeyListener,
ChangeListener,
DocumentListener,
FocusListener {
    private Frame m_parentFrame = null;
    private VWWSRRRegistryManager m_wsrrRegistryManager = null;
    private VWSession m_session = null;
    private boolean m_bFirstTime = true;
    private JSplitPane m_mainPanel = null;
    private JPanel m_browserPane = null;
    private JPanel m_blankPanel = new JPanel();
    private JTabbedPane m_tabbedPanel = new JTabbedPane();
    private JScrollPane m_wsrrRegistryPane = null;
    private JPanel m_wsrrRegistryPanel = null;
    private JScrollPane m_wsdlDocDetailsPane = null;
    private JPanel m_wsdlDocDetailsPanel = null;
    private JScrollPane m_customPropertiesPane = null;
    private JPanel m_customPropertiesPanel = null;
    private VWTable m_customPropertiesTable = null;
    private VWConfigWSRRCustomPropertiesTableModel m_tableModel = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private JLabel m_wsrrRegistryNameUI = null;
    private JLabel m_inquiryURLLabel = null;
    private JLabel m_wsrrURLLabel = null;
    private JTextArea m_wsrrURLUI = null;
    private JTextField m_wsdlDocNameUI = null;
    private JLabel m_wsdlDocNameLabel = null;
    private JTextArea m_wsdlDocNamespaceUI = null;
    private JLabel m_wsdlDocNamespaceLabel = null;
    private JTextArea m_wsdlDocLocationUI = null;
    private JLabel m_wsdlDocLocationLabel = null;
    private JTextArea m_wsdlURLUI = null;
    private JLabel m_wsdlURLLabel = null;
    private JTextArea m_wsdlDocDescriptionUI = null;
    private JLabel m_wsdlDocDescriptionLabel = null;
    private JLabel m_wsdlDocOwnerUI = null;
    private JLabel m_wsdlDocVersionUI = null;
    private JLabel m_wsdlDocLastModifiedUI = null;
    private JLabel m_wsdlDocEncodingUI = null;
    private JLabel m_wsdlDocBsrURIUI = null;
    private DefaultMutableTreeNode m_rootNode = null;
    private DefaultMutableTreeNode m_currentSelectedNode = null;
    private JTree m_tree = null;
    private DefaultTreeModel m_treeModel = null;
    private Hashtable m_objToNode = new Hashtable();
    private SearchWsdlDocuments m_wsdlSearchObject = null;
    private JPopupMenu m_popup = null;
    private JMenuItem m_logonMenuItem = null;
    private JMenuItem m_refreshMenuItem = null;
    private JMenuItem m_deleteMenuItem = null;
    private Object m_popupUserObject = null;
    private ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
    protected ItemListener m_selectListeners = null;
    private static Robot robot = null;

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:56:50  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.17  $";
    }

    public VWWSRRBrowsePanel(Frame parent, VWSession session, VWWSRRRegistryManager wsrrRegistryManager) {
        super(new BorderLayout(10, 10));
        this.m_parentFrame = parent;
        this.m_session = session;
        this.m_wsrrRegistryManager = wsrrRegistryManager;
        this.m_wsrrRegistryManager.addChangeListener(this);
        this.initData(wsrrRegistryManager);
        this.m_toolBarBorder = new VWToolbarBorder("", 0x10400000);
        this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x400000));
        this.setupLayout();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_mainPanel != null) {
                this.m_mainPanel.setDividerLocation(0.4);
                this.m_mainPanel.setDividerSize(4);
            }
        }
    }

    protected void initData(VWWSRRRegistryManager wsrrRegistryManager) {
        VWWSRRRegistryItem[] wsrrRegistryItemArray = null;
        if (wsrrRegistryManager != null) {
            wsrrRegistryItemArray = wsrrRegistryManager.getWSRRRegistryItemList();
            this.m_wsdlSearchObject = new SearchWsdlDocuments();
        }
        if (wsrrRegistryItemArray == null) {
            wsrrRegistryItemArray = new VWWSRRRegistryItem[]{};
        }
        this.m_rootNode = this.newTreeNode(wsrrRegistryItemArray);
        if (wsrrRegistryItemArray != null && wsrrRegistryItemArray.length > 0) {
            DefaultMutableTreeNode registryNode = null;
            for (int i = 0; i < wsrrRegistryItemArray.length; ++i) {
                if (wsrrRegistryItemArray[i] == null) continue;
                registryNode = this.newTreeNode(wsrrRegistryItemArray[i]);
                registryNode.setAllowsChildren(true);
                this.m_rootNode.add(registryNode);
                try {
                    if (!wsrrRegistryItemArray[i].isConnected()) continue;
                    DefaultMutableTreeNode node = this.newTreeNode(this.m_wsdlSearchObject);
                    registryNode.add(node);
                    continue;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
        } else {
            VWWSRRRegistry[] vwWSRRRegistryArray;
            VWWSRRRegistryList vwWSRRRegistryList = wsrrRegistryManager.getWSRRRegistryList();
            if (vwWSRRRegistryList != null && (vwWSRRRegistryArray = vwWSRRRegistryList.getWSRRRegistries()) != null) {
                DefaultMutableTreeNode registryNode = null;
                int regListSz = vwWSRRRegistryArray.length;
                for (int i = 0; i < regListSz; ++i) {
                    if (!vwWSRRRegistryArray[i].getPublish()) continue;
                    try {
                        VWWSRRRegistryItem vwWSRRRegItem = new VWWSRRRegistryItem(this.m_session, vwWSRRRegistryArray[i]);
                        vwWSRRRegItem.setState(0);
                        registryNode = this.newTreeNode(vwWSRRRegItem);
                        registryNode.setAllowsChildren(true);
                        this.m_rootNode.add(registryNode);
                        continue;
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex, VWResource.s_failedToCreateWSRRObject.toString(vwWSRRRegistryArray[i].getServerName()));
                    }
                }
            }
        }
        if (this.m_treeModel != null) {
            this.m_treeModel.setRoot(this.m_rootNode);
        }
    }

    protected void setupLayout() {
        this.setVisible(false);
        this.m_mainPanel = new JSplitPane(1, false);
        JScrollPane treeScrollPane = new JScrollPane(this.initTreePanel());
        this.m_browserPane = new JPanel();
        this.m_browserPane.setLayout(new BorderLayout(4, 4));
        this.m_browserPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_browserPane.add((Component)this.m_toolBarBorder, "Center");
        VWAccessibilityHelper.setAccessibility(this.m_toolBarBorder, this.m_browserPane, null, null);
        JPanel toolbarPanel = this.m_toolBarBorder.getClientPanel();
        VWAccessibilityHelper.setAccessibility(toolbarPanel, this.m_toolBarBorder, null, null);
        toolbarPanel.setLayout(new BorderLayout());
        toolbarPanel.add((Component)treeScrollPane, "Center");
        VWAccessibilityHelper.setAccessibility(treeScrollPane, toolbarPanel, null, null);
        this.initInfoPane();
        if (this.compOrientation.isLeftToRight()) {
            this.m_mainPanel.setLeftComponent(this.m_browserPane);
            this.m_mainPanel.setRightComponent(this.m_blankPanel);
        } else {
            this.m_mainPanel.setLeftComponent(this.m_blankPanel);
            this.m_mainPanel.setRightComponent(this.m_browserPane);
        }
        this.m_mainPanel.setContinuousLayout(true);
        VWAccessibilityHelper.setAccessibility(this.m_blankPanel, this.m_mainPanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_browserPane, this.m_mainPanel, null, null);
        this.add((Component)this.m_mainPanel, "Center");
        VWAccessibilityHelper.setAccessibility(this.m_mainPanel, this, null, null);
    }

    private void initInfoPane() {
        try {
            Font aFont = this.getFont();
            this.m_tabbedPanel.setFont(new Font(aFont.getName(), 1, aFont.getSize()));
            this.initWSDLDocDetailsPanel();
            this.initCustomPropertiesPanel();
            this.m_tabbedPanel.add(VWResource.s_general, this.m_wsdlDocDetailsPane);
            this.m_tabbedPanel.add(VWResource.s_customProperties, this.m_customPropertiesPane);
            VWAccessibilityHelper.setAccessibility(this.m_wsdlDocDetailsPane, this.m_tabbedPanel, VWResource.s_general, VWResource.s_general);
            VWAccessibilityHelper.setAccessibility(this.m_customPropertiesPane, this.m_tabbedPanel, VWResource.s_customProperties, VWResource.s_customProperties);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initCustomPropertiesPanel() {
        if (this.m_customPropertiesPane != null) {
            return;
        }
        this.m_customPropertiesPanel = new JPanel();
        this.m_customPropertiesPane = new JScrollPane(this.m_customPropertiesPanel);
        this.m_customPropertiesPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_wsdlCustomProperties, 0);
        this.m_customPropertiesPanel.add((Component)toolbarBorder, "First");
        VWAccessibilityHelper.setAccessibility(toolbarBorder, this.m_customPropertiesPanel, null, null);
        JPanel panel = toolbarBorder.getClientPanel();
        VWAccessibilityHelper.setAccessibility(panel, toolbarBorder, null, null);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BorderLayout());
        this.m_tableModel = new VWConfigWSRRCustomPropertiesTableModel(this.m_session, null);
        this.m_customPropertiesTable = new VWTable(this.m_tableModel);
        this.m_customPropertiesTable.setRowSelectionAllowed(true);
        this.m_customPropertiesTable.getSelectionModel().setSelectionMode(0);
        panel.add((Component)new JScrollPane(this.m_customPropertiesTable), "Center");
        VWAccessibilityHelper.setAccessibility(this.m_customPropertiesTable, panel, VWResource.s_wsdlCustomPropertiesTable, VWResource.s_wsdlCustomPropertiesTable);
    }

    private void updateCustomPropertiesPanel(WSWSRRWsdlDocument wsdlDocument) {
        this.initCustomPropertiesPanel();
        if (this.m_customPropertiesPane == null || wsdlDocument == null) {
            return;
        }
        String[] props = wsdlDocument.getUserDefinedProperties();
        this.m_tableModel.initRows(props);
        this.m_customPropertiesTable.setModel(this.m_tableModel);
    }

    private void initWSRRRegistryPanel() {
        if (this.m_wsrrRegistryPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_wsrrRegistryPanel = new JPanel();
        this.m_wsrrRegistryPane = new JScrollPane(this.m_wsrrRegistryPanel);
        VWAccessibilityHelper.setAccessibility(this.m_wsrrRegistryPanel, this.m_wsrrRegistryPane, null, null);
        this.m_wsrrRegistryPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_wsrrRegistryDetails, 0);
        this.m_wsrrRegistryPanel.add((Component)toolbarBorder, "First");
        VWAccessibilityHelper.setAccessibility(toolbarBorder, this.m_wsrrRegistryPanel, null, null);
        JPanel panel = toolbarBorder.getClientPanel();
        VWAccessibilityHelper.setAccessibility(panel, toolbarBorder, null, null);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_hostName);
        this.m_wsrrRegistryNameUI = new JLabel();
        this.m_inquiryURLLabel = new JLabel(VWResource.s_label.toString(VWResource.s_wsrrURL));
        VWAccessibilityHelper.setAccessibility(this.m_inquiryURLLabel, this.m_wsrrRegistryPanel, VWResource.s_wsrrURL, VWResource.s_wsrrURL);
        this.m_wsrrURLUI = new JTextArea();
        this.m_wsrrURLUI.setEditable(false);
        this.m_wsrrURLUI.setRows(2);
        this.m_wsrrURLUI.setColumns(20);
        this.m_wsrrURLUI.setLineWrap(true);
        this.m_wsrrURLUI.setWrapStyleWord(true);
        this.m_wsrrURLUI.setBackground(panel.getBackground());
        this.m_wsrrURLUI.setFocusable(false);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        VWAccessibilityHelper.setAccessibility(nameLabel, panel, null, null);
        c.gridy = 1;
        panel.add((Component)this.m_wsrrRegistryNameUI, c);
        VWAccessibilityHelper.setLabelFor(nameLabel, this.m_wsrrRegistryNameUI);
        VWAccessibilityHelper.setAccessibility(this.m_wsrrRegistryNameUI, panel, nameLabel.getText(), nameLabel.getText());
        c.gridy = 2;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.m_inquiryURLLabel, c);
        VWAccessibilityHelper.setAccessibility(this.m_inquiryURLLabel, panel, this.m_inquiryURLLabel.getText(), this.m_inquiryURLLabel.getText());
        this.m_wsrrURLLabel = new JLabel();
        JPanel wsrrURLPanel = new JPanel(new BorderLayout());
        wsrrURLPanel.add((Component)new JScrollPane(this.m_wsrrURLUI), "Center");
        wsrrURLPanel.add((Component)this.m_wsrrURLLabel, "After");
        c.gridy = 3;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)wsrrURLPanel, c);
        VWAccessibilityHelper.setAccessibility(this.m_wsrrURLUI, wsrrURLPanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_wsrrURLLabel, wsrrURLPanel, null, null);
        VWAccessibilityHelper.setAccessibility(wsrrURLPanel, panel, null, null);
    }

    private void updateWSRRRegistryPanel(VWWSRRRegistryItem wsrrRegistry) {
        this.initWSRRRegistryPanel();
        if (this.m_wsrrRegistryPane == null || wsrrRegistry == null) {
            return;
        }
        String hostName = wsrrRegistry.getHostName();
        if (this.m_wsrrRegistryNameUI != null) {
            this.m_wsrrRegistryNameUI.setText(wsrrRegistry.getHostName());
        }
        VWAccessibilityHelper.setAccessibility(this.m_wsrrRegistryNameUI, null, hostName, hostName);
        String url = null;
        if (this.m_wsrrURLUI != null) {
            url = wsrrRegistry.getWSRRURL();
            this.m_wsrrURLUI.setText(url);
        }
        VWAccessibilityHelper.setAccessibility(this.m_wsrrURLLabel, null, url, url);
    }

    private void initWSDLDocDetailsPanel() {
        if (this.m_wsdlDocDetailsPane != null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        this.m_wsdlDocDetailsPanel = new JPanel();
        this.m_wsdlDocDetailsPane = new JScrollPane(this.m_wsdlDocDetailsPanel);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocDetailsPanel, this.m_wsdlDocDetailsPane, null, null);
        this.m_wsdlDocDetailsPanel.setLayout(new BorderLayout());
        VWToolbarBorder toolbarBorder = new VWToolbarBorder(VWResource.s_wsdlGeneralProperties, 0);
        this.m_wsdlDocDetailsPanel.add((Component)toolbarBorder, "First");
        VWAccessibilityHelper.setAccessibility(toolbarBorder, this.m_wsdlDocDetailsPanel, null, null);
        JPanel panel = toolbarBorder.getClientPanel();
        VWAccessibilityHelper.setAccessibility(panel, toolbarBorder, null, null);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_name));
        this.m_wsdlDocNameUI = new JTextField();
        this.m_wsdlDocNameUI.setEditable(false);
        this.m_wsdlDocNameUI.setBorder(null);
        this.m_wsdlDocNameUI.setFocusable(false);
        JLabel namespaceLabel = new JLabel(VWResource.s_label.toString(VWResource.s_namespace));
        this.m_wsdlDocNamespaceUI = new JTextArea();
        this.m_wsdlDocNamespaceUI.setEditable(false);
        this.m_wsdlDocNamespaceUI.setRows(3);
        this.m_wsdlDocNamespaceUI.setColumns(20);
        this.m_wsdlDocNamespaceUI.setLineWrap(true);
        this.m_wsdlDocNamespaceUI.setWrapStyleWord(true);
        this.m_wsdlDocNamespaceUI.setBackground(panel.getBackground());
        this.m_wsdlDocNamespaceUI.setFocusable(false);
        JLabel locationLabel = new JLabel(VWResource.s_label.toString(VWResource.s_location));
        this.m_wsdlDocLocationUI = new JTextArea();
        this.m_wsdlDocLocationUI.setEditable(false);
        this.m_wsdlDocLocationUI.setRows(3);
        this.m_wsdlDocLocationUI.setColumns(20);
        this.m_wsdlDocLocationUI.setLineWrap(true);
        this.m_wsdlDocLocationUI.setWrapStyleWord(true);
        this.m_wsdlDocLocationUI.setBackground(panel.getBackground());
        this.m_wsdlDocLocationUI.setFocusable(false);
        JLabel urlLabel = new JLabel(VWResource.s_label.toString(VWResource.s_wsdlURL));
        this.m_wsdlURLUI = new JTextArea();
        this.m_wsdlURLUI.setEditable(false);
        this.m_wsdlURLUI.setRows(3);
        this.m_wsdlURLUI.setColumns(20);
        this.m_wsdlURLUI.setLineWrap(true);
        this.m_wsdlURLUI.setWrapStyleWord(true);
        this.m_wsdlURLUI.setBackground(panel.getBackground());
        this.m_wsdlURLUI.setFocusable(false);
        JLabel descriptionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_description));
        this.m_wsdlDocDescriptionUI = new JTextArea();
        this.m_wsdlDocDescriptionUI.setEditable(false);
        this.m_wsdlDocDescriptionUI.setRows(3);
        this.m_wsdlDocDescriptionUI.setColumns(20);
        this.m_wsdlDocDescriptionUI.setLineWrap(true);
        this.m_wsdlDocDescriptionUI.setWrapStyleWord(true);
        this.m_wsdlDocDescriptionUI.setBackground(panel.getBackground());
        this.m_wsdlDocDescriptionUI.setFocusable(false);
        JLabel ownerLabel = new JLabel(VWResource.s_label.toString(VWResource.s_owner));
        this.m_wsdlDocOwnerUI = new JLabel();
        JLabel versionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_version));
        this.m_wsdlDocVersionUI = new JLabel();
        JLabel lastModifiedLabel = new JLabel(VWResource.s_label.toString(VWResource.s_lastModified));
        this.m_wsdlDocLastModifiedUI = new JLabel();
        JLabel encodingLabel = new JLabel(VWResource.s_label.toString(VWResource.s_encoding));
        this.m_wsdlDocEncodingUI = new JLabel();
        JLabel bsrURILabel = new JLabel(VWResource.s_label.toString(VWResource.s_bsrURI));
        this.m_wsdlDocBsrURIUI = new JLabel();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        VWAccessibilityHelper.setAccessibility(nameLabel, panel, VWResource.s_name, VWResource.s_name);
        ++c.gridy;
        JPanel wsdlDocNamePanel = new JPanel(new BorderLayout());
        this.m_wsdlDocNameLabel = new JLabel();
        wsdlDocNamePanel.add((Component)new JScrollPane(this.m_wsdlDocNameUI), "Center");
        wsdlDocNamePanel.add((Component)this.m_wsdlDocNameLabel, "After");
        panel.add((Component)wsdlDocNamePanel, c);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocNameLabel, wsdlDocNamePanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocNameUI, wsdlDocNamePanel, null, null);
        VWAccessibilityHelper.setAccessibility(wsdlDocNamePanel, panel, null, null);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)namespaceLabel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel wsdlDocNamespacePanel = new JPanel(new BorderLayout());
        this.m_wsdlDocNamespaceLabel = new JLabel();
        wsdlDocNamespacePanel.add((Component)new JScrollPane(this.m_wsdlDocNamespaceUI), "Center");
        wsdlDocNamespacePanel.add((Component)this.m_wsdlDocNamespaceLabel, "After");
        panel.add((Component)wsdlDocNamespacePanel, c);
        VWAccessibilityHelper.setAccessibility(namespaceLabel, panel, VWResource.s_namespace, VWResource.s_namespace);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocNamespaceUI, wsdlDocNamespacePanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocNamespaceLabel, wsdlDocNamespacePanel, null, null);
        VWAccessibilityHelper.setAccessibility(wsdlDocNamespacePanel, panel, null, null);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)locationLabel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel wsdlDocLocationPanel = new JPanel(new BorderLayout());
        this.m_wsdlDocLocationLabel = new JLabel();
        wsdlDocLocationPanel.add((Component)new JScrollPane(this.m_wsdlDocLocationUI), "Center");
        wsdlDocLocationPanel.add((Component)this.m_wsdlDocLocationLabel, "After");
        panel.add((Component)wsdlDocLocationPanel, c);
        VWAccessibilityHelper.setAccessibility(locationLabel, panel, VWResource.s_location, VWResource.s_location);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocLocationLabel, wsdlDocLocationPanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocLocationUI, wsdlDocLocationPanel, null, null);
        VWAccessibilityHelper.setAccessibility(wsdlDocLocationPanel, panel, null, null);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)urlLabel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel wsdlURLPanel = new JPanel(new BorderLayout());
        this.m_wsdlURLLabel = new JLabel();
        wsdlURLPanel.add((Component)new JScrollPane(this.m_wsdlURLUI), "Center");
        wsdlURLPanel.add((Component)this.m_wsdlURLLabel, "After");
        panel.add((Component)wsdlURLPanel, c);
        VWAccessibilityHelper.setAccessibility(urlLabel, panel, VWResource.s_wsdlURL, VWResource.s_wsdlURL);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlURLUI, wsdlURLPanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlURLLabel, wsdlURLPanel, null, null);
        VWAccessibilityHelper.setAccessibility(wsdlURLPanel, panel, null, null);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)descriptionLabel, c);
        ++c.gridy;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel wsdlDocDescriptionPanel = new JPanel(new BorderLayout());
        this.m_wsdlDocDescriptionLabel = new JLabel();
        wsdlDocDescriptionPanel.add((Component)new JScrollPane(this.m_wsdlDocDescriptionUI), "Center");
        wsdlDocDescriptionPanel.add((Component)this.m_wsdlDocDescriptionLabel, "After");
        panel.add((Component)wsdlDocDescriptionPanel, c);
        VWAccessibilityHelper.setAccessibility(descriptionLabel, panel, VWResource.s_description, VWResource.s_description);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocDescriptionUI, wsdlDocDescriptionPanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocDescriptionLabel, wsdlDocDescriptionPanel, null, null);
        VWAccessibilityHelper.setAccessibility(wsdlDocDescriptionPanel, panel, null, null);
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)ownerLabel, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocOwnerUI, c);
        VWAccessibilityHelper.setAccessibility(ownerLabel, panel, VWResource.s_owner, VWResource.s_owner);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocOwnerUI, panel, null, null);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)versionLabel, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocVersionUI, c);
        VWAccessibilityHelper.setAccessibility(versionLabel, panel, VWResource.s_version, VWResource.s_version);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocVersionUI, panel, null, null);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)lastModifiedLabel, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocLastModifiedUI, c);
        VWAccessibilityHelper.setAccessibility(lastModifiedLabel, panel, VWResource.s_lastModified, VWResource.s_lastModified);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocLastModifiedUI, panel, null, null);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)encodingLabel, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocEncodingUI, c);
        VWAccessibilityHelper.setAccessibility(encodingLabel, panel, VWResource.s_encoding, VWResource.s_encoding);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocEncodingUI, panel, null, null);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)bsrURILabel, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.m_wsdlDocBsrURIUI, c);
        VWAccessibilityHelper.setAccessibility(bsrURILabel, panel, VWResource.s_bsrURI, VWResource.s_bsrURI);
        VWAccessibilityHelper.setAccessibility(this.m_wsdlDocBsrURIUI, panel, null, null);
    }

    private void updateWSDLDocDetailsPanel(WSWSRRWsdlDocument wsdlDocument) {
        this.initWSDLDocDetailsPanel();
        if (this.m_wsdlDocDetailsPane == null || wsdlDocument == null) {
            return;
        }
        if (this.m_wsdlDocNameUI != null) {
            this.m_wsdlDocNameUI.setText(wsdlDocument.getName());
            VWAccessibilityHelper.setAccessibility(this.m_wsdlDocNameLabel, null, this.m_wsdlDocNameUI.getText(), this.m_wsdlDocNameUI.getText());
        }
        if (this.m_wsdlDocNamespaceUI != null) {
            this.m_wsdlDocNamespaceUI.setText(wsdlDocument.getNamespace());
            VWAccessibilityHelper.setAccessibility(this.m_wsdlDocNamespaceLabel, null, this.m_wsdlDocNamespaceUI.getText(), this.m_wsdlDocNamespaceUI.getText());
        }
        if (this.m_wsdlDocLocationUI != null) {
            this.m_wsdlDocLocationUI.setText(wsdlDocument.getLocation());
            VWAccessibilityHelper.setAccessibility(this.m_wsdlDocLocationLabel, null, this.m_wsdlDocLocationUI.getText(), this.m_wsdlDocLocationUI.getText());
        }
        if (this.m_wsdlURLUI != null) {
            this.m_wsdlURLUI.setText(wsdlDocument.getP8WSRRDocumentURI());
            VWAccessibilityHelper.setAccessibility(this.m_wsdlURLLabel, null, this.m_wsdlURLUI.getText(), this.m_wsdlURLUI.getText());
        }
        if (this.m_wsdlDocDescriptionUI != null) {
            this.m_wsdlDocDescriptionUI.setText(wsdlDocument.getDescription());
            VWAccessibilityHelper.setAccessibility(this.m_wsdlDocDescriptionLabel, null, this.m_wsdlDocDescriptionUI.getText(), this.m_wsdlDocDescriptionUI.getText());
        }
        if (this.m_wsdlDocOwnerUI != null) {
            this.m_wsdlDocOwnerUI.setText(wsdlDocument.getOwner());
        }
        if (this.m_wsdlDocVersionUI != null) {
            this.m_wsdlDocVersionUI.setText(wsdlDocument.getVersion());
        }
        if (this.m_wsdlDocLastModifiedUI != null) {
            Date date;
            Long dateLong;
            String lastModified = wsdlDocument.getLastModified();
            this.m_wsdlDocLastModifiedUI.setText(null);
            if (lastModified != null && (dateLong = new Long(lastModified)) != null && (date = new Date(dateLong)) != null) {
                this.m_wsdlDocLastModifiedUI.setText(date.toString());
            }
        }
        if (this.m_wsdlDocEncodingUI != null) {
            this.m_wsdlDocEncodingUI.setText(wsdlDocument.getEncoding());
        }
        if (this.m_wsdlDocBsrURIUI != null) {
            this.m_wsdlDocBsrURIUI.setText(wsdlDocument.getBsrURI());
        }
        this.m_wsdlDocDetailsPane.updateUI();
    }

    private JPanel initBrowserPanel() {
        this.m_browserPane = new JPanel();
        this.m_browserPane.setLayout(new BorderLayout(4, 4));
        this.m_browserPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_browserPane.add((Component)this.m_toolBarBorder, "First");
        VWAccessibilityHelper.setAccessibility(this.m_toolBarBorder, this.m_browserPane, null, null);
        return this.m_browserPane;
    }

    private JPanel initTreePanel() {
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout(10, 10));
        this.m_tree = new JTree(this.m_rootNode);
        this.m_tree.setName("BrowseTree.VWWSRRBrowsePanel");
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.m_tree.setCellRenderer(new VWWSRRBrowseTreeCellRenderer());
        treePanel.add(this.m_tree);
        VWAccessibilityHelper.setAccessibility(this.m_tree, treePanel, VWResource.s_wsrrRegistryTree, VWResource.s_wsrrRegistryTree);
        this.m_tree.addTreeSelectionListener(this);
        this.m_tree.addTreeWillExpandListener(this);
        this.m_tree.addMouseListener(this);
        this.m_tree.addKeyListener(this);
        this.m_tree.addFocusListener(this);
        TreeModel treeModel = this.m_tree.getModel();
        if (treeModel != null && treeModel instanceof DefaultTreeModel) {
            this.m_treeModel = (DefaultTreeModel)treeModel;
        }
        return treePanel;
    }

    private DefaultMutableTreeNode newTreeNode(Object obj) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(obj);
        this.m_objToNode.put(obj, node);
        return node;
    }

    private void setTreeNodeUserObject(DefaultMutableTreeNode node, Object obj) {
        if (node.getUserObject() != null) {
            if (this.m_objToNode.get(node.getUserObject()) != null) {
                this.m_objToNode.remove(node.getUserObject());
            }
            node.setUserObject(obj);
            this.m_objToNode.put(obj, node);
        }
    }

    private void removeAllChildren(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> enum1 = node.children();
        TreeNode obj = null;
        DefaultMutableTreeNode child = null;
        while (enum1.hasMoreElements()) {
            obj = enum1.nextElement();
            if (obj == null || !(obj instanceof DefaultMutableTreeNode)) continue;
            child = (DefaultMutableTreeNode)obj;
            this.removeAllChildren(child);
            node.removeAllChildren();
            this.m_objToNode.remove(child);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        Object userObject = null;
        if (this.m_currentSelectedNode == null) {
            return;
        }
        userObject = this.m_currentSelectedNode.getUserObject();
        if (userObject == null) {
            return;
        }
        try {
            switch (event.getID()) {
                case 0x400000: {
                    this.onRefresh();
                    break;
                }
                case 0x10000000: {
                    this.onDelete();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Object userObject = null;
        if (this.m_currentSelectedNode == null) {
            return;
        }
        userObject = this.m_currentSelectedNode.getUserObject();
        if (userObject == null) {
            return;
        }
        if (source == this.m_logonMenuItem) {
            this.onLogon(this.m_currentSelectedNode);
        } else if (source == this.m_refreshMenuItem) {
            this.onRefresh();
        } else if (source == this.m_deleteMenuItem && userObject != null) {
            this.onDelete();
        }
    }

    private void onDelete() {
        if (this.m_currentSelectedNode == null) {
            return;
        }
        Object userObject = this.m_currentSelectedNode.getUserObject();
        if (userObject instanceof WSWSRRWsdlDocument) {
            WSWSRRWsdlDocument document = (WSWSRRWsdlDocument)userObject;
            if (document == null) {
                return;
            }
            TreeNode parent = this.m_currentSelectedNode.getParent();
            VWWSRRRegistryItem registryItem = null;
            if (parent != null && parent instanceof DefaultMutableTreeNode) {
                Object obj = ((DefaultMutableTreeNode)parent).getUserObject();
                if (obj != null && obj instanceof VWWSRRRegistryItem) {
                    registryItem = (VWWSRRRegistryItem)obj;
                }
                if (registryItem == null) {
                    return;
                }
                VWWSRRProcessMonitorDialog publishMonitor = new VWWSRRProcessMonitorDialog(this.m_parentFrame, this.m_wsrrRegistryManager, registryItem, document, 2, VWResource.s_deleteService);
                publishMonitor.setVisible(true);
                publishMonitor.releaseResources();
                int status = publishMonitor.getStatus();
                if (status == 1) {
                    ((DefaultMutableTreeNode)parent).remove(this.m_currentSelectedNode);
                    if (this.m_treeModel != null) {
                        this.m_treeModel.nodeStructureChanged(parent);
                    }
                    this.m_tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)parent).getPath()));
                }
            }
        }
    }

    private void onLogon(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof VWWSRRRegistryItem) {
            VWWSRRRegistryItem registryItem = (VWWSRRRegistryItem)userObject;
            this.m_wsrrRegistryManager.authenticateForPublish(this.m_parentFrame, registryItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRefresh() {
        block13: {
            String nodeName = "";
            Cursor currentCursor = null;
            Object userObject = this.m_currentSelectedNode.getUserObject();
            if (userObject == null) {
                return;
            }
            try {
                block12: {
                    currentCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (userObject instanceof VWWSRRRegistryItem) {
                        VWWSRRRegistryItem registryItem = (VWWSRRRegistryItem)userObject;
                        nodeName = registryItem.getHostName();
                        boolean bConnected = false;
                        try {
                            block11: {
                                try {
                                    if (!registryItem.isConnected()) break block11;
                                    bConnected = true;
                                    registryItem.refresh();
                                    this.getWsdlDocuments(this.m_currentSelectedNode);
                                }
                                catch (Exception ex) {
                                    this.showMessage(VWResource.s_failedToRefreshWSRR.toString(nodeName), VWResource.s_refresh, 1, ex);
                                    VWDebug.logException(ex);
                                    Object var8_7 = null;
                                    if (bConnected) break block12;
                                    this.m_currentSelectedNode.removeAllChildren();
                                    if (this.m_treeModel != null) {
                                        this.m_treeModel.nodeStructureChanged(this.m_currentSelectedNode);
                                    }
                                    break block12;
                                }
                            }
                            Object var8_6 = null;
                            if (bConnected) break block12;
                            this.m_currentSelectedNode.removeAllChildren();
                            if (this.m_treeModel != null) {
                                this.m_treeModel.nodeStructureChanged(this.m_currentSelectedNode);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (bConnected) throw throwable;
                            this.m_currentSelectedNode.removeAllChildren();
                            if (this.m_treeModel == null) throw throwable;
                            this.m_treeModel.nodeStructureChanged(this.m_currentSelectedNode);
                            throw throwable;
                        }
                    }
                }
                Object var10_11 = null;
                if (currentCursor == null) break block13;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (currentCursor != null) {
                    this.setCursor(currentCursor);
                }
                this.updateUI();
                throw throwable;
            }
            this.setCursor(currentCursor);
        }
        this.updateUI();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.m_selectListeners = AWTEventMulticaster.add(this.m_selectListeners, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.m_selectListeners = AWTEventMulticaster.remove(this.m_selectListeners, listener);
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private DefaultMutableTreeNode getSelectedTreeNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        return node;
    }

    public Object[] getSelectedObjects() {
        Object nodeInfo = this.getSelectedObject();
        if (nodeInfo != null) {
            Object[] objects = null;
            objects = new Object[]{nodeInfo};
            return objects;
        }
        return null;
    }

    protected void notifySelectListeners() {
        ItemEvent event = new ItemEvent(this, 0, null, 1);
        if (this.m_selectListeners != null) {
            this.m_selectListeners.itemStateChanged(event);
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath selPath = event.getPath();
        if (selPath == null) {
            return;
        }
        this.m_currentSelectedNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        Object nodeInfo = this.getSelectedObject();
        if (nodeInfo != null) {
            TreeNode[] nodes = this.m_treeModel.getPathToRoot(this.getSelectedTreeNode());
            if (nodes != null && nodes.length > 0) {
                Object obj = null;
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i] == null || !(nodes[i] instanceof DefaultMutableTreeNode) || (obj = ((DefaultMutableTreeNode)nodes[i]).getUserObject()) == null || !(obj instanceof VWWSRRRegistryItem)) continue;
                    VWWSRRRegistryItem currentRegistryItem = (VWWSRRRegistryItem)obj;
                }
            }
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x400000));
            JComponent newComponent = null;
            if (nodeInfo instanceof VWWSRRRegistryItem[]) {
                newComponent = this.m_blankPanel;
            } else if (nodeInfo instanceof VWWSRRRegistryItem) {
                VWWSRRRegistryItem regItem = (VWWSRRRegistryItem)nodeInfo;
                this.updateWSRRRegistryPanel(regItem);
                newComponent = this.m_wsrrRegistryPane;
                if (regItem.getState() != 0) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x400000));
                }
            } else if (nodeInfo instanceof WSWSRRWsdlDocument) {
                WSWSRRWsdlDocument regItem = (WSWSRRWsdlDocument)nodeInfo;
                this.updateWSDLDocDetailsPanel(regItem);
                this.updateCustomPropertiesPanel(regItem);
                newComponent = this.m_tabbedPanel;
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
            }
            this.notifySelectListeners();
            if (newComponent != null) {
                int dividerLocation = this.m_mainPanel.getDividerLocation();
                if (this.compOrientation.isLeftToRight()) {
                    this.m_mainPanel.setRightComponent(newComponent);
                } else {
                    this.m_mainPanel.setLeftComponent(newComponent);
                }
                this.m_mainPanel.setDividerLocation(dividerLocation);
                this.m_mainPanel.setDividerSize(3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getWsdlDocuments(DefaultMutableTreeNode treeNode) throws Exception {
        Object obj = null;
        obj = treeNode.getUserObject();
        if (obj == null) return;
        if (!(obj instanceof VWWSRRRegistryItem)) return;
        Cursor currentCursor = null;
        try {
            currentCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.m_wsdlSearchObject.searchWsdlDocs(treeNode);
            Object var6_4 = null;
            if (currentCursor == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (currentCursor == null) throw throwable;
            this.setCursor(currentCursor);
            throw throwable;
        }
        this.setCursor(currentCursor);
    }

    private int showMessage(String msg, String title, int msgType) {
        return this.showMessage(msg, title, msgType, null);
    }

    private int showMessage(String msg, String title, int msgType, Exception ex) {
        int retStatus = 0;
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        retStatus = VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, title, msgType);
        return retStatus;
    }

    private int showOptionDialog(String msg, String title, int msgType, int optionType) {
        int retStatus = VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, title, msgType, optionType, null, null, 0, 0);
        return retStatus;
    }

    private void showPopup(int x, int y) {
    }

    private void showPopup(Object source, int x, int y) {
        Object userObject;
        Object obj;
        TreePath path;
        if (source == this.m_tree && (path = this.m_tree.getPathForLocation(x, y)) != null && (obj = path.getLastPathComponent()) != null && obj instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)obj).getUserObject()) != null && (userObject instanceof VWWSRRRegistryItem || userObject instanceof WSWSRRWsdlDocument)) {
            this.m_popupUserObject = userObject;
            this.createPopup(this, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPopup(Container container, int x, int y) {
        if (this.m_popup == null) {
            this.m_popup = new JPopupMenu();
        } else {
            this.m_popup.removeAll();
        }
        if (this.m_logonMenuItem == null) {
            this.m_logonMenuItem = new JMenuItem(VWResource.s_logon);
            this.m_logonMenuItem.addActionListener(this);
        }
        if (this.m_refreshMenuItem == null) {
            this.m_refreshMenuItem = new JMenuItem(VWResource.s_refresh);
            this.m_refreshMenuItem.addActionListener(this);
        }
        if (this.m_deleteMenuItem == null) {
            this.m_deleteMenuItem = new JMenuItem(VWResource.s_delete);
            this.m_deleteMenuItem.addActionListener(this);
        }
        if (this.m_popupUserObject != null) {
            if (this.m_popupUserObject instanceof VWWSRRRegistryItem) {
                VWWSRRRegistryItem regItem = (VWWSRRRegistryItem)this.m_popupUserObject;
                boolean bConnected = false;
                try {
                    block20: {
                        try {
                            if (!regItem.isConnected()) break block20;
                            bConnected = true;
                            if (regItem.isAuthenticated()) break block20;
                            this.m_popup.add(this.m_logonMenuItem);
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                            Object var8_8 = null;
                            if (!bConnected) {
                                this.m_currentSelectedNode.removeAllChildren();
                                if (this.m_treeModel != null) {
                                    this.m_treeModel.nodeStructureChanged(this.m_currentSelectedNode);
                                }
                            }
                        }
                    }
                    Object var8_7 = null;
                    if (!bConnected) {
                        this.m_currentSelectedNode.removeAllChildren();
                        if (this.m_treeModel != null) {
                            this.m_treeModel.nodeStructureChanged(this.m_currentSelectedNode);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (!bConnected) {
                        this.m_currentSelectedNode.removeAllChildren();
                        if (this.m_treeModel != null) {
                            this.m_treeModel.nodeStructureChanged(this.m_currentSelectedNode);
                        }
                    }
                    throw throwable;
                }
                if (regItem.getState() != 0) {
                    this.m_popup.add(this.m_refreshMenuItem);
                }
            } else if (this.m_popupUserObject instanceof WSWSRRWsdlDocument) {
                WSWSRRWsdlDocument docItem = (WSWSRRWsdlDocument)this.m_popupUserObject;
                this.m_popup.add(this.m_deleteMenuItem);
            }
        }
        this.m_popup.show(container, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        try {
            TreeNode childNode;
            DefaultMutableTreeNode treeNode;
            TreePath treePath = event.getPath();
            Object obj = treePath.getLastPathComponent();
            if (obj == null || !(obj instanceof DefaultMutableTreeNode) || (treeNode = (DefaultMutableTreeNode)obj).getChildCount() != 1 || (childNode = treeNode.getChildAt(0)) == null || !(childNode instanceof DefaultMutableTreeNode)) return;
            Object userObject = treeNode.getUserObject();
            Object childUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
            if (userObject == null || childUserObject == null) return;
            if (userObject instanceof VWWSRRRegistryItem && childUserObject instanceof SearchWsdlDocuments) {
                boolean bConnected = false;
                try {
                    block7: {
                        try {
                            VWWSRRRegistryItem registryItem = (VWWSRRRegistryItem)userObject;
                            if (!registryItem.isConnected()) break block7;
                            bConnected = true;
                            this.getWsdlDocuments(treeNode);
                        }
                        catch (Exception ex) {
                            this.showMessage(VWResource.s_failedToRetrieveDocuments.toString(treeNode), VWResource.s_refresh, 1, ex);
                            VWDebug.logException(ex);
                            Object var11_13 = null;
                            if (bConnected) return;
                            treeNode.removeAllChildren();
                            if (this.m_treeModel == null) return;
                            this.m_treeModel.nodeStructureChanged(this.m_currentSelectedNode);
                            return;
                        }
                    }
                    Object var11_12 = null;
                    if (bConnected) return;
                    treeNode.removeAllChildren();
                    if (this.m_treeModel == null) return;
                    this.m_treeModel.nodeStructureChanged(this.m_currentSelectedNode);
                    return;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (bConnected) throw throwable;
                    treeNode.removeAllChildren();
                    if (this.m_treeModel == null) throw throwable;
                    this.m_treeModel.nodeStructureChanged(this.m_currentSelectedNode);
                    throw throwable;
                }
            }
            if (!(userObject instanceof WSWSRRWsdlDocument)) return;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event.getSource(), event.getPoint().x, event.getPoint().y);
        } else {
            int selRow = this.m_tree.getRowForLocation(event.getX(), event.getY());
            this.m_tree.setSelectionRow(selRow);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e.getSource(), e.getPoint().x, e.getPoint().y);
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 121: {
                int row;
                Rectangle rect;
                int modifiers = event.getModifiers();
                if ((modifiers & 1) == 0) break;
                robot.keyPress(27);
                robot.keyRelease(27);
                int x = 10;
                int y = 10;
                if (!(event.getSource() instanceof JTree)) break;
                JTree tree = (JTree)event.getSource();
                TreePath path = tree.getSelectionPath();
                if (path != null && (rect = tree.getRowBounds(row = tree.getRowForPath(path))) != null) {
                    x = rect.x + 2 * rect.width / 3;
                    y = rect.y + 2 * rect.height / 3;
                }
                this.showPopup(event.getSource(), x, y);
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void focusGained(FocusEvent e) {
        if (this.m_tree.getRowCount() > 0 && this.m_tree.getSelectionCount() == 0) {
            this.m_tree.addSelectionInterval(0, 0);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        if (source instanceof VWWSRREvent) {
            VWWSRREvent wsrrEvent = (VWWSRREvent)source;
            Object obj = wsrrEvent.getSource();
            int type = wsrrEvent.getEventType();
            if (obj != null && obj instanceof VWWSRRRegistryItem) {
                TreeNode aRegNode;
                VWWSRRRegistryItem regItem = (VWWSRRRegistryItem)wsrrEvent.getSource();
                if (type == 5 && (aRegNode = this.findRegistryNode(this.m_rootNode, regItem)) != null) {
                    DefaultMutableTreeNode registryNode = (DefaultMutableTreeNode)aRegNode;
                    this.setTreeNodeUserObject(registryNode, regItem);
                    registryNode.setAllowsChildren(true);
                    try {
                        if (regItem.isConnected()) {
                            DefaultMutableTreeNode node = this.newTreeNode(this.m_wsdlSearchObject);
                            registryNode.add(node);
                        }
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                    this.validate();
                    this.updateUI();
                }
            }
        } else if (source instanceof VWWSRRRegistryItem) {
            try {
                Object obj = this.m_objToNode.get(source);
                if (obj != null && obj instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
                    if (treeNode.isLeaf()) {
                        this.getWsdlDocuments(treeNode);
                    } else {
                        obj = treeNode.getFirstChild();
                        if (obj != null && obj instanceof DefaultMutableTreeNode) {
                            this.getWsdlDocuments((DefaultMutableTreeNode)obj);
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void insertUpdate(DocumentEvent event) {
    }

    public void removeUpdate(DocumentEvent event) {
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public boolean hasUnpublishedData() {
        String msg = this.checkUnPublishedData(this.m_rootNode);
        return msg != null && msg.length() > 0;
    }

    public boolean onClosePanel() {
        int ret;
        String msg = this.checkUnPublishedData(this.m_rootNode);
        return msg == null || msg.length() <= 0 || (ret = this.showOptionDialog(VWResource.s_closePublishDialogWarning + "\n\n" + msg, VWResource.s_publish, 3, 5)) != 4;
    }

    private String checkUnPublishedData(DefaultMutableTreeNode node) {
        String retMsg = "";
        Object userObject = node.getUserObject();
        if (userObject instanceof VWWSRRRegistryItem[] || userObject instanceof VWWSRRRegistryItem) {
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                retMsg = retMsg + this.checkUnPublishedData((DefaultMutableTreeNode)node.getChildAt(i));
            }
        }
        return retMsg;
    }

    private TreeNode findRegistryNode(TreeNode node, VWWSRRRegistryItem vwWSRRRegistryItem) {
        TreeNode aNode = null;
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            VWWSRRRegistryItem regItem;
            String regName;
            TreeNode childNode = node.getChildAt(i);
            Object userObject = ((DefaultMutableTreeNode)childNode).getUserObject();
            if (!(userObject instanceof VWWSRRRegistryItem) || (regName = vwWSRRRegistryItem.getHostName()).compareTo((regItem = (VWWSRRRegistryItem)userObject).getHostName()) != 0) continue;
            aNode = childNode;
            break;
        }
        return aNode;
    }

    static {
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    class SearchWsdlDocuments {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void searchWsdlDocs(DefaultMutableTreeNode treeNode) throws Exception {
            block9: {
                block10: {
                    String nodeName = null;
                    if (treeNode == null) {
                        return;
                    }
                    try {
                        Object obj = treeNode.getUserObject();
                        if (obj == null || !(obj instanceof VWWSRRRegistryItem)) break block9;
                        VWWSRRRegistryItem regItem = (VWWSRRRegistryItem)obj;
                        if (regItem == null) {
                            Object var11_6 = null;
                            break block10;
                        }
                        treeNode.removeAllChildren();
                        nodeName = regItem.getHostName();
                        WSWSRRRegistry wsWSRRRegistry = regItem.getWSWSRRRegistry();
                        Object[] wsrrDocs = wsWSRRRegistry.retrieveRegionWSDLDocuments();
                        if (wsrrDocs != null && wsrrDocs.length > 0) {
                            VWQuickSort sort = new VWQuickSort(wsrrDocs, 0);
                            sort.sort(0, wsrrDocs.length - 1);
                            for (int i = 0; i < wsrrDocs.length; ++i) {
                                if (wsrrDocs[i] == null) continue;
                                DefaultMutableTreeNode serviceNode = VWWSRRBrowsePanel.this.newTreeNode(wsrrDocs[i]);
                                treeNode.add(serviceNode);
                            }
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var11_8 = null;
                        if (VWWSRRBrowsePanel.this.m_treeModel == null) throw throwable;
                        VWWSRRBrowsePanel.this.m_treeModel.nodeStructureChanged(treeNode);
                        throw throwable;
                    }
                }
                if (VWWSRRBrowsePanel.this.m_treeModel == null) return;
                VWWSRRBrowsePanel.this.m_treeModel.nodeStructureChanged(treeNode);
                return;
            }
            Object var11_7 = null;
            if (VWWSRRBrowsePanel.this.m_treeModel == null) return;
            VWWSRRBrowsePanel.this.m_treeModel.nodeStructureChanged(treeNode);
        }
    }
}

